package ru.yandex.chemodan.videostreaming.framework.util;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IntervalRunner {
    private final Duration runInterval;

    public IntervalRunner(Duration runInterval) {
        this.runInterval = runInterval;
    }

    public void runAsyncIfAppropriate(Option<Instant> lastRunTimeO, Runnable runnable) {
        if (lastRunTimeO.isMatch(this::intervalIsPassed)) {
            CommonThreadPoolHolder.runAsync(runnable);
        }
    }

    private boolean intervalIsPassed(Instant lastRunTime) {
        return new Duration(lastRunTime, Instant.now())
                .isLongerThan(runInterval);
    }
}
