package ru.yandex.chemodan.videostreaming.framework.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IntervalRunnerTest {
    private static final IntervalRunner SUT = new IntervalRunner(Duration.standardHours(1));

    @Test
    public void runnableMustBeInvokedWhenIntervalIsPassed() {
        Assert.isTrue(checkIfRanAsync(Instant.now().minus(Duration.standardHours(2))));
    }

    @Test
    public void runnableMustNotBeInvokedWhenIntervalIsNotPassed() {
        Assert.isFalse(checkIfRanAsync(Instant.now().minus(Duration.standardMinutes(10))));
    }

    private static boolean checkIfRanAsync(Instant instant) {
        CompletableFuture<Void> runnableInvoked = new CompletableFuture<>();
        SUT.runAsyncIfAppropriate(Option.of(instant), () -> runnableInvoked.complete(null));
        try {
            runnableInvoked.get(1, TimeUnit.SECONDS);
            return true;
        } catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtils.translate(e);
        } catch (TimeoutException e) {
            return false;
        }
    }
}
