package ru.yandex.chemodan.videostreaming.framework.util;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class RequestAccessChecker {
    private static final Logger logger = LoggerFactory.getLogger(RequestAccessChecker.class);

    private final SetF<String> internalHosts;

    private final SetF<String> externalPaths;

    public RequestAccessChecker(SetF<String> internalHosts, SetF<String> externalPaths) {
        this.internalHosts = internalHosts;
        this.externalPaths = externalPaths;
        logger.info("Considering following hosts as internal: {}", internalHosts);
    }

    public boolean isFromInternalHost(HttpServletRequest request) {
        return Option.ofNullable(request.getServerName())
                .map(String::toLowerCase)
                .isMatch(internalHosts::containsTs);
    }

    public boolean isFromExternalHost(HttpServletRequest request) {
        return !isFromInternalHost(request);
    }

    public boolean isInternalPath(HttpServletRequest request) {
        return Option.ofNullable(request.getServletPath())
                .map(String::toLowerCase)
                .isMatch(currentPath -> !externalPaths.exists(currentPath::startsWith));
    }

    public boolean isForbidden(HttpServletRequest request) {
        return isFromExternalHost(request) && isInternalPath(request);
    }
}
