package ru.yandex.chemodan.videostreaming.framework.util;

import java.util.function.Consumer;
import java.util.function.Supplier;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.log.reqid.RequestIdStack;
import ru.yandex.misc.worker.Executable;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class RequestIdHelper {
    private static volatile Supplier<String> generateF = RequestIdStack::generateId;

    private static volatile Supplier<Option<String>> getCurrentF = RequestIdStack::current;

    private static volatile Consumer<String> pushF = RequestIdStack::pushReplace;

    private static volatile Runnable popF = RequestIdStack::pop;

    public static void runWithRequestId(Runnable runnable, String requestId) {
        try {
            executeWithRequestId(runnable::run, requestId);
        } catch (Exception e) {
            throw (RuntimeException) e;
        }
    }

    public static void executeWithRequestId(Executable executable) throws Exception {
        executeWithRequestId(executable, generateF.get());
    }

    public static void executeWithRequestId(Executable executable, String requestId) throws Exception {
        pushF.accept(requestId);
        try {
            executable.execute();
        } finally {
            popF.run();
        }
    }

    public static Option<String> getCurrentRequestIdO() {
        return getCurrentF.get();
    }

    public static String getCurrentRequestId() {
        return getCurrentF.get().get();
    }

    public static synchronized void setFunctions(Supplier<String> generateF,
            Supplier<Option<String>> getCurrentF,
            Consumer<String> pushF, Runnable popF)
    {
        RequestIdHelper.pushF = pushF;
        RequestIdHelper.popF = popF;
        RequestIdHelper.getCurrentF = getCurrentF;
        RequestIdHelper.generateF = generateF;
    }
}
