package ru.yandex.chemodan.videostreaming.framework.util;

import ru.yandex.chemodan.http.DiskJetty;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.misc.web.servlet.WtdFilter;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SingleWarJettyUtil {
    public static SingleWarJetty consSingleWarJetty(int httpPort, int maxThreads, int minThreads, int maxQueueLength) {
        DiskJetty jetty = new DiskJetty("vid");

        jetty.setHttpPort(httpPort);

        jetty.setMaxThreads(maxThreads);
        jetty.setMinThreads(minThreads);
        jetty.setMaxQueueLength(maxQueueLength);
        jetty.setCopyBeanPostprocessors(true);
        jetty.setLookupServletsInContext(false);

        jetty.addFilterMapping("/*", new WtdFilter());

        jetty.setRequestLogFactory(DiskLog4jRequestLog.consF());

        return jetty;
    }

    private SingleWarJettyUtil() {}
}
