package ru.yandex.chemodan.videostreaming.framework.util;

import java.util.function.Supplier;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.log.TskvNdcUtil;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TimeAndSuccessLogUtil {
    public static void runLoggingTimeAndSuccess(Runnable runnable, String message, Logger logger, Object... extraNdc) {
        execLoggingTimeAndSuccess(
                () -> { runnable.run(); return null; },
                message,
                logger,
                extraNdc
        );
    }

    public static <T> T execLoggingTimeAndSuccess(Supplier<T> supplier, String message, Logger logger,
            Object... extraNdc)
    {
        long start = System.currentTimeMillis();
        try {
            T result = supplier.get();
            log(logger, message, Option.empty(), start, extraNdc);
            return result;
        } catch (RuntimeException ex) {
            log(logger, message, Option.of(ex), start, extraNdc);
            throw ex;
        }
    }

    private static void log(Logger logger, String message, Option<RuntimeException> exceptionO, long start,
            Object... extraNdc)
    {
        String duration = TimeUtils.millisecondsToSecondsStringToNow(start);
        ListF<Object> loggingArgs = Cf.<Object>list(
                message,
                !exceptionO.isPresent() ? "completed successfully" : "failed",
                duration
        ).plus(exceptionO);
        TskvNdcUtil.runWithNdc(
                () -> logger.log(
                        !exceptionO.isPresent() ? Level.INFO : Level.ERROR,
                        "{} {}; took {}",
                        loggingArgs.toArray()
                ),
                Tuple2List.fromPairs(extraNdc)
                        .map1(Object::toString)
                        .plus1("request_time", duration)
                        .plus1("status", !exceptionO.isPresent() ? "success" : "failure")
        );
    }
}
