package ru.yandex.chemodan.videostreaming.framework.util.system;

import java.util.function.Supplier;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class AppCpuTime {
    private static final double CLOCK_TICKS_PER_SECOND = GetConfVariables.CLOCK_TICKS_PER_SECOND;

    private static final Supplier<Option<Double>> CPU_TIME_SUPPLIER =
            LinuxProcFs.isAvailable()
                    ? () -> Option.of(LinuxProcFs.readSelfProcessStat().getTotalTime() / CLOCK_TICKS_PER_SECOND)
                    : Option::empty;

    public static Snapshot getCpuTime() {
        return new Snapshot();
    }

    public static class Snapshot extends DefaultObject {
        public final Instant p_createdAt = Instant.now();

        public final Option<Double> p_cpuTimeO;

        private Snapshot() {
            this(CPU_TIME_SUPPLIER.get());
        }

        Snapshot(Option<Double> cpuTimeO) {
            this.p_cpuTimeO = cpuTimeO;
        }

        Instant getCreatedAt() {
            return p_createdAt;
        }

        Option<Double> getCpuTimeO() {
            return p_cpuTimeO;
        }
    }

    public static class Interval extends DefaultObject {
        public final Snapshot start;

        public final Snapshot end;

        public Interval(Snapshot start, Snapshot end) {
            this.start = start;
            this.end = end;
        }

        public Duration getDuration() {
            return new Duration(start.getCreatedAt(), end.getCreatedAt());
        }

        public Option<Double> getCpuTimeO() {
            return Option.when(
                    start.getCpuTimeO().isPresent() && end.getCpuTimeO().isPresent(),
                    () -> end.getCpuTimeO().get() - start.getCpuTimeO().get()
            );
        }

        public Option<Double> getLoadO() {
            return getCpuTimeO()
                    .map(cpuTime -> cpuTime / getDuration().getMillis() * 1000);
        }
    }
}
