package ru.yandex.chemodan.videostreaming.framework.util.system;

import org.joda.time.Instant;
import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class AppCpuTimeTest {
    @Test
    public void testIntervalHasDataWhenBothSnapshotHasValues() {
        AppCpuTime.Interval interval = new AppCpuTime.Interval(
                mockSnapshot(1, new Instant(0)),
                mockSnapshot(3, new Instant(500))
        );
        Assert.some(2D, interval.getCpuTimeO());
        Assert.some(4d, interval.getLoadO());
    }

    @Test
    public void testIntervalIsWithoutDataWhenSnapshotIsWithoutValue() {
        AppCpuTime.Interval interval = new AppCpuTime.Interval(
                new AppCpuTime.Snapshot(Option.empty()),
                mockSnapshot(3, new Instant(500))
        );
        Assert.none(interval.getCpuTimeO());
        Assert.none(interval.getLoadO());
    }

    private static AppCpuTime.Snapshot mockSnapshot(double cpuTime, Instant createdAt) {
        AppCpuTime.Snapshot mock = Mockito.mock(AppCpuTime.Snapshot.class);
        Mockito.when(mock.getCpuTimeO())
                .thenReturn(Option.of(cpuTime));
        Mockito.when(mock.getCreatedAt())
                .thenReturn(createdAt);
        return mock;
    }
}
