package ru.yandex.chemodan.videostreaming.framework.util.system;

import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.io.exec.ExecUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class GetConfVariables {
    private static final Logger logger = LoggerFactory.getLogger(GetConfVariables.class);

    public static final int CLOCK_TICKS_PER_SECOND = Integer.parseInt(get("CLK_TCK"));

    private static String get(@SuppressWarnings("SameParameterValue") String variable) {
        try {
            ExecResult execResult = ExecUtils.executeGrabbingOutput("/usr/bin/getconf", variable);
            execResult.checkSuccess();
            return StringUtils.strip(execResult.getStdout());
        } catch (RuntimeException ex) {
            logger.error("Error while reading {} variable", variable);
            throw ex;
        }
    }
}
