package ru.yandex.chemodan.videostreaming.framework.util.threadlocal;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.ThreadLocalX;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ReplicableThreadLocal<T> extends ThreadLocalX<T> {
    private static final ListF<ReplicableThreadLocal> instances = Cf.arrayList();

    public ReplicableThreadLocal() {
        instances.add(this);
    }

    public void runWith(T value, Runnable runnable) {
        T prevValue = get();
        try {
            setOrRemoveIfNull(value);
            runnable.run();
        } finally {
            setOrRemoveIfNull(prevValue);
        }
    }

    private State getState() {
        return new State();
    }

    private void setOrRemoveIfNull(T value) {
        if (value != null) {
            set(value);
        } else {
            remove();
        }
    }

    public static Runnable attachTo(Runnable runnable) {
        ListF<ReplicableThreadLocal.State> states =
                instances.map(ReplicableThreadLocal::getState)
                        .filter(ReplicableThreadLocal.State::hasValue);
        return () -> {
            ListF<ReplicableThreadLocal.State> prevStates = Cf.arrayList();
            try {
                for(ReplicableThreadLocal.State state : states) {
                    prevStates.add(state.applyReturningPrev());
                }

                runnable.run();
            } finally {
                prevStates.forEach(ReplicableThreadLocal.State::apply);
            }
        };
    }

    private class State extends DefaultObject {
        final T value = get();

        void apply() {
            setOrRemoveIfNull(value);
        }

        State applyReturningPrev() {
            State prev = new State();
            apply();
            return prev;
        }

        boolean hasValue() {
            return value != null;
        }
    }
}
