package ru.yandex.chemodan.videostreaming.framework.util.threadlocal;

import ru.yandex.chemodan.videostreaming.framework.util.RequestIdHelper;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ReplicateThreadLocalsUtil {
    public static Runnable attachTo(Runnable runnable) {
        return withCurrentRequestId(ReplicableThreadLocal.attachTo(runnable));

    }

    private static Runnable withCurrentRequestId(Runnable runnable) {
        return RequestIdHelper.getCurrentRequestIdO() // RID must be received in current thread
                .map(rid -> (Runnable) () -> RequestIdHelper.runWithRequestId(runnable, rid))
                .getOrElse(runnable);
    }
}
