package ru.yandex.chemodan.videostreaming.framework.util.threadlocal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatchers;
import org.objenesis.ObjenesisHelper;

import ru.yandex.misc.lang.Check;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TlOverrideDynamicProxy<T> extends DefaultObject {
    private final T proxy;

    private final T primaryValue;

    private final ReplicableThreadLocal<T> threadLocalValue = new ReplicableThreadLocal<>();

    public TlOverrideDynamicProxy(T primaryValue, Class<T> clazz) {
        this.proxy = consInvocationHandler(clazz, new MethodInterceptorImpl());
        this.primaryValue = primaryValue;
    }

    private static <T> T consInvocationHandler(Class<T> clazz, InvocationHandler invocationHandler) {
        DynamicType.Loaded<T> proxyClass = new ByteBuddy()
                .subclass(clazz)
                .method(ElementMatchers.any())
                .intercept(InvocationHandlerAdapter.of(invocationHandler))
                .make()
                .load(clazz.getClassLoader());

        return ObjenesisHelper.newInstance(proxyClass.getLoaded());
    }

    public T getProxy() {
        return proxy;
    }

    public void runWith(T value, Runnable runnable) {
        if (value != proxy) {
            threadLocalValue.runWith(value, runnable);
        } else {
            runnable.run();
        }
    }

    private T get() {
        T value = threadLocalValue.getO().getOrElse(primaryValue);
        checkNotSameAsProxy(value);
        return value;
    }

    private void checkNotSameAsProxy(T value) {
        Check.isTrue(proxy != value, "Invalid API usage - proxy MUST not refer itself");
    }

    private class MethodInterceptorImpl implements InvocationHandler {
        @Override
        public Object invoke(Object obj, Method method, Object[] args) throws ReflectiveOperationException {
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(get(), args);
            } else {
                method.setAccessible(true);
                try {
                    return method.invoke(get(), args);
                } finally {
                    method.setAccessible(false);
                }
            }
        }
    }
}
