package ru.yandex.chemodan.videostreaming.framework.util.threadlocal;

import org.junit.Test;

import ru.yandex.chemodan.videostreaming.framework.util.threadlocal.test.TestPojo;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TlOverrideDynamicProxyTest {
    private static final TestPojo TEST_POJO_1 = new TestPojo("value1");

    private static final TestPojo TEST_POJO_2 = new TestPojo("value2");

    @Test
    public void byDefaultProxyReturnsSameValue() {
        Assert.equals(
                "value1",
                new TlOverrideDynamicProxy<>(TEST_POJO_1, TestPojo.class)
                        .getProxy()
                        .getValue()
        );
    }

    @Test
    public void whenOverriddenProxyReturnsOverriddenValue() {
        TlOverrideDynamicProxy<TestPojo> overridable = new TlOverrideDynamicProxy<>(TEST_POJO_1, TestPojo.class);
        overridable.runWith(
                TEST_POJO_2,
                () -> Assert.equals("value2", overridable.getProxy().getValue())
        );
    }

    @Test
    public void defaultValueEqualsProxy() {
        Assert.equals(
                TEST_POJO_1,
                new TlOverrideDynamicProxy<>(TEST_POJO_1, TestPojo.class)
                        .getProxy()
        );
    }

    @Test
    public void protectedMethodIsAccessible() {
        TEST_POJO_1.publicMethod(
                new TlOverrideDynamicProxy<>(TEST_POJO_1, TestPojo.class)
                        .getProxy()
        );
    }
}
