package ru.yandex.chemodan.videostreaming.framework.web;

import lombok.RequiredArgsConstructor;
import lombok.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.ip.IpAddress;

/**
 * @author lemeh
 */
public class BannedIpRegistry {
    private final ZkRegistry<String, BannedIpRegistry.StringIpAddress> registry;

    private volatile ListF<IpAddress> ips = Cf.list();

    public BannedIpRegistry(ZkManager zkManager, ZkPath path) {
        registry = new ZkRegistry<>(path, Bender.cons(StringIpAddress.class), StringIpAddress::getValue, s -> s);
        registry.addListener(state -> ips = state.map(StringIpAddress::toIpAddress));
        zkManager.addClient(registry);
    }

    public ListF<IpAddress> getIps() {
        return ips;
    }

    public boolean has(IpAddress ip) {
        return ips.containsTs(ip);
    }

    public void add(IpAddress ip) {
        registry.put(new StringIpAddress(ip));
    }

    public void remove(IpAddress ip) {
        registry.remove(ip.toString());
    }

    @BenderBindAllFields
    @Value
    @RequiredArgsConstructor
    static final class StringIpAddress {
        String value;

        StringIpAddress(IpAddress ipAddress) {
            this(ipAddress.toString());
        }

        public IpAddress toIpAddress() {
            return IpAddress.parse(value);
        }
    }
}
