package ru.yandex.chemodan.videostreaming.framework.web;

import java.io.ByteArrayInputStream;
import java.lang.management.ManagementFactory;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.HlsSegmentSource;
import ru.yandex.chemodan.videostreaming.framework.hls.stats.FFUtilStats;
import ru.yandex.chemodan.videostreaming.framework.hls.stats.HlsRequestStats;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
@BenderBindAllFields
class DebugInfo extends DefaultObject {
    static final BenderSerializer<DebugInfo> serializer = new BenderMapper().createSerializer(DebugInfo.class);

    @SuppressWarnings("unused")
    final double loadAverage1min = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();

    final String dimension;

    @SuppressWarnings("unused")
    final HlsSegmentSource source = HlsRequestStats.getCurrent().getSourceO().get();

    @SuppressWarnings("unused")
    final long duration = new Duration(HlsRequestStats.getCurrent().getCreatedAt(), Instant.now()).getMillis();

    DebugInfo(Dimension dimension) {
        this.dimension = dimension.toImageMagickSize();
    }

    static DebugInfo cons(HlsStreamQuality quality) {
        return new DebugInfo(
                quality.getDimensionFor(
                        FFUtilStats.getCurrent()
                                .getFileInformationO()
                                .get()
                                .getVideoStream()
                )
        );
    }

    ByteArrayInputStream toByteArrayInputStream() {
        return new ByteArrayInputStream(serializer.serializeJson(this));
    }
}
