package ru.yandex.chemodan.videostreaming.framework.web;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface HlsErrorSource {
    HlsError getHlsError();

    default HlsError getEffectiveHlsError() {
        if (!(this instanceof Throwable)) {
            return getHlsError();
        }

        Throwable t = (Throwable) this;
        if (!(t.getCause() instanceof HlsErrorSource)) {
            return getHlsError();
        }

        HlsErrorSource cause = (HlsErrorSource) t.getCause();
        return cause.getEffectiveHlsError();
    }

    class HlsError extends DefaultObject {
        public final int statusCode;

        public final String description;

        public HlsError(int statusCode, String description) {
            this.statusCode = statusCode;
            this.description = description;
        }
    }
}
