package ru.yandex.chemodan.videostreaming.framework.web;

import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.chemodan.videostreaming.framework.accesscheck.BasicAccessChecker;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsRequest;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.chemodan.videostreaming.framework.hls.sourcemeta.SourceMetaParser;
import ru.yandex.chemodan.videostreaming.framework.stidblocker.InMemoryStidBlocker;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsRequestParserTest {
    @Test
    public void parseWithQuality1() {
        assertParse(
                "/stid/timestamp/sign/360p/playlist.m3u8",
                new HlsRequest<>("playlist.m3u8", "", HlsStreamQuality._360P)
        );
    }

    @Test
    public void parseWithQuality2() {
        assertParse(
                "/stid/timestamp/sign/240p/1.ts",
                new HlsRequest<>("1.ts", "", HlsStreamQuality._240P)
        );
    }

    @Test
    public void parseWithoutQuality() {
        assertParse(
                "/stid/timestamp/sign/master-playlist.m3u8",
                new HlsRequest<>("master-playlist.m3u8", "", Option.empty())
        );
    }

    @Test(expected = SourceMetaParser.AccessForbiddenException.class)
    public void parseBannedStid() {
        InMemoryStidBlocker stidBlocker = new InMemoryStidBlocker(Cf.set("stid"));
        HlsRequestParser<MpfsSourceMeta> parser =
                new HlsRequestParser<>(request -> new MpfsSourceMeta(MulcaId.valueOf("stid", ""), Option.empty(),
                        Option.empty(), true, Option.empty()),
                BasicAccessChecker.alwaysNone(),
                BannedIpUpdater.noop(), stidBlocker);
        StreamingHttpServletRequest request = Mockito.mock(StreamingHttpServletRequest.class);
        Mockito.when(request.getPathInfo()).thenReturn("/stid/timestamp/sign/360p/playlist.m3u8");
        Mockito.when(request.getXRealIp()).thenReturn(Option.empty());
        parser.parse(request);
    }

    private static void assertParse(String path, HlsRequest<String> expected) {
        HlsRequestParser<String> parser = new HlsRequestParser<>(request -> "", BasicAccessChecker.alwaysNone(),
                BannedIpUpdater.noop(), new InMemoryStidBlocker());
        StreamingHttpServletRequest request = Mockito.mock(StreamingHttpServletRequest.class);
        Mockito.when(request.getPathInfo()).thenReturn(path);
        Mockito.when(request.getXRealIp()).thenReturn(Option.empty());
        Assert.equals(expected, parser.parse(request));
    }
}
