package ru.yandex.chemodan.videostreaming.framework.web;

import ru.yandex.chemodan.videostreaming.framework.hls.HlsParams;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsParamsBySourceOverriderProvider;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsResponse;
import ru.yandex.chemodan.videostreaming.framework.hls.sourcemeta.SourceMetaParser;
import ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.HlsVideoInfoManager;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsVideoInfoServlet<T> extends AbstractHlsServlet {
    public static final String URL_PREFIX = "info";

    private final HlsVideoInfoManager<T> manager;

    private final SourceMetaParser<T> sourceMetaParser;

    private final HlsParamsBySourceOverriderProvider<T> hlsParamsBySourceOverriderProvider;

    private final HlsParams hlsParams;

    public HlsVideoInfoServlet(HlsVideoInfoManager<T> manager, SourceMetaParser<T> sourceMetaParser,
            HlsParamsBySourceOverriderProvider<T> hlsParamsBySourceOverriderProvider, HlsParams hlsParams)
    {
        this.manager = manager;
        this.sourceMetaParser = sourceMetaParser;
        this.hlsParamsBySourceOverriderProvider = hlsParamsBySourceOverriderProvider;
        this.hlsParams = hlsParams;
    }

    @Override
    protected void doGet(StreamingHttpServletRequest req, HttpServletResponseX resp) {
        Boolean disableCache = req.parseBoolean("disable_cache", false);
        T sourceMeta = parse(req);
        hlsParams.consOverridable()
                .withVideoInfoParams(builder -> builder.cacheDisabled(disableCache))
                .override(hlsParamsBySourceOverriderProvider.get(sourceMeta))
                .run(() -> handle(sourceMeta, new HlsResponse(req, resp)));
    }

    private void handle(T sourceMeta, HlsResponse hlsResponse) {
        manager.handleRequest(sourceMeta, hlsResponse);
    }

    private T parse(StreamingHttpServletRequest req) {
        return sourceMetaParser.parse(req);
    }
}
