package ru.yandex.chemodan.videostreaming.framework.web;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.filter.OncePerRequestFilter;

import ru.yandex.chemodan.videostreaming.framework.util.RequestAccessChecker;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class InternalAccessFilter extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(InternalAccessFilter.class);

    private final RequestAccessChecker accessChecker;

    public InternalAccessFilter(RequestAccessChecker accessChecker) {
        this.accessChecker = accessChecker;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
            throws ServletException, IOException
    {
        if (accessChecker.isForbidden(request)) {
            response.sendError(HttpStatus.SC_403_FORBIDDEN);
            logger.warn("Internal resource access forbidden: server name = {}, servlet path = {}",
                    request.getServerName(),
                    request.getServletPath()
            );
        } else {
            filterChain.doFilter(request, response);
        }
    }
}
