package ru.yandex.chemodan.videostreaming.framework.web;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.videostreaming.framework.util.RequestAccessChecker;
import ru.yandex.misc.io.http.HttpStatus;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class InternalAccessFilterTest {
    private static final String EXTERNAL_SERVER_NAME = "streaming.disk.yandex.net";

    private static final String INTERNAL_SERVER_NAME = "streaming-int.disk.yandex.net";

    private HttpServletResponse response;

    private FilterChain filterChain;

    @Before
    public void setUp() {
        response = mock(HttpServletResponse.class);
        filterChain = mock(FilterChain.class);
    }

    @Test
    public void send403ForExternalServerNameAndInternalPath() throws ServletException, IOException {
        doFilterInternal(EXTERNAL_SERVER_NAME, "/ping");
        verify(response, times(1))
                .sendError(HttpStatus.SC_403_FORBIDDEN);
    }

    @Test
    public void doFilterForInternalServerNameAndInternalPath() throws ServletException, IOException {
        doFilterInternal(INTERNAL_SERVER_NAME, "/ping");
        verify(filterChain, times(1))
                .doFilter(any(), any());
    }

    @Test
    public void doFilterForExternalServerNameAndExternalPath() throws ServletException, IOException {
        doFilterInternal(EXTERNAL_SERVER_NAME, "/hls/blah/blah/1.ts");
        verify(filterChain, times(1))
                .doFilter(any(), any());
    }

    private void doFilterInternal(String serverName, String path) throws ServletException, IOException {
        HttpServletRequest request = setUpHttpServletRequest(serverName, path);
        new InternalAccessFilter(new RequestAccessChecker(Cf.set(INTERNAL_SERVER_NAME), Cf.set("/hls")))
                .doFilterInternal(request, response, filterChain);
    }

    private static HttpServletRequest setUpHttpServletRequest(String serverName, String path) {
        HttpServletRequest request = mock(HttpServletRequest.class);
        when(request.getServerName())
                .thenReturn(serverName);
        when(request.getServletPath())
                .thenReturn(path);
        return request;
    }
}
