package ru.yandex.chemodan.videostreaming.framework.web;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.ip.Network;
import ru.yandex.misc.test.Assert;

public class IpByNetworkMatcherTest {
    @Test
    public void testFetchList() {
        SetF<Network> networks = Cf.list("24.25.26.0/24", "24.25.0.0/16").map(Network::valueOf).unique();
        IpByNetworkMatcher ipMatcher = new IpByNetworkMatcher(() -> networks);
        ipMatcher.update();
        Assert.notEmpty(ipMatcher.getNetworks());
        ipMatcher.getNetworks().forEach(network ->
                Assert.isTrue(ipMatcher.matches(network.getAddress())));
    }
}
