package ru.yandex.chemodan.videostreaming.framework.web;

import java.math.BigInteger;

import ru.yandex.misc.ip.IpAddress;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IpProximityUtil {
    public static boolean areNearby(IpAddress ip1, IpAddress ip2, long maxIpv4Distance, long maxIpv6Distance) {
        long maxDistance = ip1.isIpv6Address() || ip2.isIpv6Address() ? maxIpv6Distance : maxIpv4Distance;
        return areNearby(ip1, ip2, maxDistance);
    }

    public static boolean areNearby(IpAddress ip1, IpAddress ip2, long maxDistance) {
        return calcDistance(ip1, ip2)
                .compareTo(BigInteger.valueOf(maxDistance)) <= 0;
    }

    private static BigInteger calcDistance(IpAddress ip1, IpAddress ip2) {
        return new BigInteger(ip1.getBytes())
                .subtract(new BigInteger(ip2.getBytes()))
                .abs();
    }
}
