package ru.yandex.chemodan.videostreaming.framework.web;

import org.junit.Test;

import ru.yandex.misc.ip.IpAddress;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IpProximityUtilTest {
    @Test
    public void testWhenNearby() {
        assertAreNearby("88.246.15.123", "88.248.15.123", Double.valueOf(2 * Math.pow(256, 2)).longValue());
    }

    @Test
    public void testWhenDistant() {
        assertAreDistant("88.248.15.100", "88.248.15.102", 1);
    }

    @Test
    public void testWhenEqual() {
        assertAreNearby("88.248.15.100", "88.248.15.100", 0);
    }

    @Test
    public void testIpv6() {
        assertAreNearby(
                "2806:109f:4:6c13:f520:94f4:d6f8:f081",
                "2806:109f:4:6c13:f520:94f4:d6f8:f080",
                1);

    }

    private static void assertAreNearby(String ip1, String ip2, long maxDistance) {
        Assert.isTrue(IpProximityUtil.areNearby(IpAddress.parse(ip1), IpAddress.parse(ip2), maxDistance));
    }

    @SuppressWarnings("SameParameterValue")
    private static void assertAreDistant(String ip1, String ip2, int maxDistance) {
        Assert.isFalse(IpProximityUtil.areNearby(IpAddress.parse(ip1), IpAddress.parse(ip2), maxDistance));
    }
}
