package ru.yandex.chemodan.videostreaming.framework.web;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.chemodan.videostreaming.framework.hls.StreamingUrlParams;
import ru.yandex.chemodan.videostreaming.framework.util.StringParamConverter;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class StreamingHttpServletRequest extends HttpServletRequestX implements StringParamConverter {
    public StreamingHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public StreamingUrlParams getUrlParams() {
        return StreamingUrlParams.fromHttpServletRequestX(this)
                .withUseHttp(parseBoolean("use_http", false));
    }

    public boolean isExtM3uSessionDataEnabled() {
        try {
            return parseIntegerO("session_data").getOrElse(0) == 1;
        } catch (NumberFormatException ex) {
            return false;
        }
    }
}
