package ru.yandex.chemodan.videostreaming.framework.web;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

import ru.yandex.chemodan.videostreaming.framework.util.RequestAccessChecker;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * This error handler makes HTTP error response very simple (only &lt;b>ERROR&lt;/b> is outputted),
 *
 * @author Dmitriy Amelin (lemeh)
 * @author Roman Nefyodov
 * @see ru.yandex.misc.web.servletContainer.jetty.MuteErrorHandler
 */
public class VideoStreamingMuteErrorHandler extends ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(VideoStreamingMuteErrorHandler.class);

    private final RequestAccessChecker accessChecker;

    public VideoStreamingMuteErrorHandler(RequestAccessChecker accessChecker) {
        this.accessChecker = accessChecker;
    }

    @Override
    public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response)
            throws IOException
    {
        if (accessChecker.isFromExternalHost(request)) {
            logger.info("Rewrite response with code {}", response.getStatus());
            response.setStatus(response.getStatus());
        }

        super.handle(s, baseRequest, request, response);
    }

    @Override
    protected void writeErrorPageBody(HttpServletRequest request, Writer writer, int code, String message, boolean b)
            throws IOException
    {
        if (accessChecker.isFromExternalHost(request)) {
            writer.write(getErrorBody());
            logger.info("Muted error message: {}", message);
        } else {
            super.writeErrorPageBody(request, writer, code, message, b);
        }
    }

    protected String getErrorBody() {
        return "<h2>ERROR</h2>";
    }
}
