package ru.yandex.chemodan.app.webdav;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.misc.ThreadLocalX;

/**
 * @author tolmalev
 */
public class AddAuthTypeInterceptor implements HttpRequestInterceptor {
    private static final ThreadLocalX<AuthInfo.AuthType> authType = new ThreadLocalX<>();
    private static final String AUTH_TYPE_HEADER = "X-Auth-Method";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        authType.getO().forEach(authType -> {
            request.addHeader(AUTH_TYPE_HEADER, authType.toString());
        });
    }

    public void setAuthType(AuthInfo.AuthType authType) {
        this.authType.set(authType);
    }

    public void clearAuthType() {
        authType.remove();
    }
}
