package ru.yandex.chemodan.app.webdav;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.xml.Namespace;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.webdav.log.WebdavApiTskvLogPatternLayout;
import ru.yandex.chemodan.app.webdav.log.WebdavApiTskvLogger;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.commune.zk2.admin.ZkAdminContextConfiguration;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.http.apache.v4.InstrumentedDefaultHttpClient;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author tolmalev
 */
public class WebDavMain extends ChemodanMainSupport {
    public static void main(String[] args) {
        try {
            //XXX: hack to make prefix "d" instead of "D"

            Field field = DavConstants.class.getDeclaredField("NAMESPACE");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & ~Modifier.FINAL);

            field.set(DavConstants.class, Namespace.getNamespace("d", "DAV:"));
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }

        new WebDavMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "webdav");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                ZkAdminContextConfiguration.class,
                WebDavContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {

        Log4jHelper.rootLoggerBuilder().appName(applicationName()).build();

        Log4jHelper.accessLoggerBuilder()
                .tskvFormat("ydisk-java-webdav-access-log")
                .appName(applicationName())
                .build();

        Log4jHelper.appenderBuilder()
                .appName(applicationName())
                .name(WebdavApiTskvLogger.tskvLogger.name)
                .postfix("-api")
                .layout(new WebdavApiTskvLogPatternLayout())
                .build();

        // disable logs:
        // message=Stale connection check
        // message=Attempt 1 to execute request
        // message=Connection can be kept alive indefinitely
        Log4jHelper.configureLogger(InstrumentedDefaultHttpClient.class, Level.INFO);
    }
}
