package ru.yandex.chemodan.app.webdav.auth;

import lombok.AllArgsConstructor;
import org.apache.jackrabbit.webdav.DavException;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mpfs.MpfsUser;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.protocol.response.Karma;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@AllArgsConstructor
public class AuthInfo extends DefaultObject implements MpfsUser {
    // don't do this!
    // not final
    // public static final AuthInfo DEFAULT

    public final Option<PassportUid> uid;
    public final Option<Karma> karma;
    public final Option<String> login;
    public final Option<String> teamLogin;

    public final Option<String> firstname;
    public final Option<String> lastname;
    public final Option<String> country;
    public final Option<String> lang;

    public final boolean isB2b;
    public final Option<String> clientId;

    public final Option<OurClient> ourClient;
    public final ClientCapabilities clientCapabilities;
    public final Option<Boolean> isPrivileged;
    public final Option<Boolean> canUserUseOrdinaryPasswordForWebdav;

    public final AuthType authType;

    public final boolean needsInit;

    public AuthInfo(Option<OurClient> ourClient, ClientCapabilities clientCapabilities) {
        this(Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty(),
                Option.empty(), Option.empty(), Option.empty(), false, Option.empty(),
                ourClient, clientCapabilities, Option.empty(), Option.empty(), AuthType.NONE, false);
    }

    @Override
    public String getUidStr() {
        return uid.map(Object::toString).getOrElse("0");
    }

    public boolean isOurClient() {
        return ourClient.isPresent();
    }

    public boolean isAuthorized() {
        return authType.isAuthorized();
    }

    public DavException buildUnauthorizedException() {
        if (canUserUseOrdinaryPasswordForWebdav.isPresent() && !canUserUseOrdinaryPasswordForWebdav.get()) {
            return new DavException(HttpStatus.SC_401_UNAUTHORIZED,
                    "https://yandex.ru/support/disk-desktop/webdav-app-passwords.html");
        } else {
            return new DavException(HttpStatus.SC_401_UNAUTHORIZED);
        }
    }

    public enum AuthType {
        NONE(false),
        BANNED(false),
        BAD_SCOPE(false),

        BASIC(true),
        OAUTH(true);

        private final boolean authorized;

        AuthType(boolean authorized) {

            this.authorized = authorized;
        }

        public boolean isAuthorized() {
            return authorized;
        }

        public boolean isBasic() {
            return this == BASIC;
        }

        public boolean isOauth() {
            return this == OAUTH;
        }
    }

    public static AuthInfo getDefault() {
        return new AuthInfo(Option.empty(), ClientCapabilities.getDefault());
    }
}
