package ru.yandex.chemodan.app.webdav.auth;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@Getter
@Setter
@AllArgsConstructor
public class ClientCapabilities extends DefaultObject {
    // don't do this!
    // not final
    // public static ClientCapabilities DEFAULT;

    private boolean getRedirect;
    private boolean putRedirect;
    private boolean putAlwaysRedirect;
    private boolean useAutohide;
    private String baseLocation;
    private boolean delete200;

    public static ClientCapabilities getDefault() {
        return new ClientCapabilities(false, false, false, false, "/disk", false);
    }
}
