package ru.yandex.chemodan.app.webdav.callback;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
public class MpfsCallbackServlet extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(MpfsCallbackServlet.class);
    private final MpfsCallbacksManager manager;

    public MpfsCallbackServlet(MpfsCallbacksManager manager) {
        this.manager = manager;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestBody = IOUtils.toString(req.getInputStream());
        try {
            Option.ofNullable(req.getParameter("id"))
                .forEach(id -> manager.callbackReceived(id, requestBody));
        } catch (Exception e) {
            log.error("Failed request body: " + requestBody);
            throw ExceptionUtils.translate(e);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        doGet(req, resp);
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        doGet(req, resp);
    }

    @Override
    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        doGet(req, resp);
    }
}
