package ru.yandex.chemodan.app.webdav.callback;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.http.DiskJetty;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.chemodan.util.web.CustomYcridPrefixResolver;
import ru.yandex.misc.env.Environment;
import ru.yandex.misc.ip.IpPort;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.web.servlet.WtdFilter;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author tolmalev
 */
@Configuration
public class MpfsCallbacksContextConfiguration {
    @Bean
    public MpfsCallbacksManager mpfsCallbacksManager(
            @Value("${internal.http.port}")
            int callbacksPort,
            @Value("${mpfs.callback.timeout}")
            Duration ourClientTimeout,
            @Value("${sync.operation.timeout}")
            Duration otherClientTimeout)
    {
        if (Environment.isDeveloperNotebook()) {
            // because mpfs callbacks can't be received to notebook
            ourClientTimeout = Duration.standardSeconds(1);
            otherClientTimeout = Duration.standardSeconds(1);
        }
        return new MpfsCallbacksManager(callbacksPort, ourClientTimeout, otherClientTimeout);
    }

    @Bean
    public MpfsCallbackServlet callbackServlet(
            MpfsCallbacksManager manager,
            @Qualifier("internalJetty")
            SingleWarJetty jetty)
    {
        MpfsCallbackServlet servlet = new MpfsCallbackServlet(manager);
        jetty.addServletMapping("/callback/*", servlet);
        return servlet;
    }

    //TODO: use this jetty not only for callbacks
    @Bean
    public DiskJetty internalJetty(
            AppName appName,
            CustomYcridPrefixResolver customYcridPrefixResolver,
            @Value("${internal.http.port}")
            IpPort port,
            @Value("${a3.maxThreads}")
            int maxThreads,
            @Value("${a3.minThreads}")
            int minThreads,
            @Value("${a3.maxQueueLength}")
            int maxQueueLength,
            @Value("${a3.acceptQueueSize}")
            String acceptQueueSizeStr)
    {
        DiskJetty jetty = new DiskJetty(customYcridPrefixResolver::getPrefix);

        jetty.setHttpPort(port.getPort());
        jetty.setMaxThreads(maxThreads);
        jetty.setMaxThreads(minThreads);
        jetty.setMaxQueueLength(maxQueueLength);
        jetty.setLookupServletsInContext(false);
        jetty.addFilterMapping("/*", new WtdFilter());

        jetty.setRequestLogFactory(DiskLog4jRequestLog.consF());

        if (!acceptQueueSizeStr.isEmpty()) {
            jetty.setAcceptQueueSize(Integer.parseInt(acceptQueueSizeStr));
        }

        return jetty;
    }
}
