package ru.yandex.chemodan.app.webdav.callback;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.http.HttpStatus;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
@AllArgsConstructor
@Getter
public class MpfsOperationCallbackData extends DefaultObject {
    public static final BenderParserSerializer<MpfsOperationCallbackData> PS =
            Bender.cons(MpfsOperationCallbackData.class);

    private final String status;
    private final Option<OperationError> error;

    public boolean isOk() {
        return "done".equalsIgnoreCase(status);
    }

    public int getErrorResponseCode() {
        return error.flatMapO(OperationError::getResponse).getOrElse(HttpStatus.SC_INTERNAL_SERVER_ERROR);
    }

    public Option<String> getErrorTitleO() {
        return error.flatMapO(OperationError::getTitle);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Getter
    private static final class OperationError {
        private final Option<Integer> response;
        private final Option<String> title;
    }
}
