package ru.yandex.chemodan.app.webdav.log;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.filter.AuthenticationFilter;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.chemodan.log.TskvLogger;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxOAuthInfo;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author yashunsky
 */
public class WebdavApiTskvLogger {
    public static final TskvLogger tskvLogger = new TskvLogger("webdav-api");

    public static final String CLIENT_INFO_ATTRIBUTE = "api-oauth-client-info";

    public static void log(HttpServletRequest request, HttpServletResponse response) {
        AuthInfo authInfo = AuthenticationFilter.getAuthInfo(request);
        if (authInfo.isOurClient()) {
            return;
        }

        String clientImpl;

        String sdkHeader = request.getHeader("X-Yandex-Sdk-Version");
        String sdkPlatform = "";
        String sdkVersion = "";

        if (authInfo.authType.isOauth() && sdkHeader != null) {
            clientImpl = "sdk";
            ListF<String> sdkParams = Cf.x(sdkHeader.split(",")).map(String::trim);
            sdkPlatform = sdkParams.getO(0).getOrElse("");
            sdkVersion = sdkParams.getO(1).getOrElse("");
        } else if (authInfo.authType.isOauth()) {
            clientImpl = "webdav";
        } else if (authInfo.authType.isBasic()) {
            clientImpl = "basic_webdav";
        } else {
            return;
        }

        Option<BlackboxOAuthInfo> oAuthInfo =
                Option.ofNullable((BlackboxOAuthInfo) request.getAttribute(CLIENT_INFO_ATTRIBUTE));

        HttpServletRequestX wrappedReq = HttpServletRequestX.wrap(request);
        String agent = wrappedReq.getUserAgent().getOrElse("-");

        tskvLogger.log(Tuple2List.fromPairs(
                "client_impl", clientImpl,
                "login", authInfo.login.getOrElse("-"),
                "method", request.getMethod(),
                "new_user", String.valueOf(authInfo.needsInit),
                "oauth_id", oAuthInfo.map(BlackboxOAuthInfo::getClientId).getOrElse(""),
                "oauth_name", oAuthInfo.map(BlackboxOAuthInfo::getClientName).getOrElse(""),
                "puid", authInfo.getUidStr(),
                "request_uri", request.getRequestURI(),
                "status_code", DiskLog4jRequestLog.getStatus(request, response),
                "user_agent", agent,
                "sdk_platform", sdkPlatform,
                "sdk_ver", sdkVersion
        ));
    }
}
