package ru.yandex.chemodan.app.webdav.repository;

import java.io.IOException;
import java.util.List;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.PropEntry;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;

/**
 * @author tolmalev
 */
public abstract class AbstractMpfsDavResource implements MpfsResource {

    @Override
    public String getComplianceClass() {
        return "1,2";
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public DavResourceLocator getLocator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getResourcePath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void spool(OutputContext outputContext) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DavPropertyName[] getPropertyNames() {
        return getProperties().getPropertyNames();
    }

    @Override
    public DavProperty<?> getProperty(DavPropertyName name) {
        return getProperties().get(name);
    }

    @Override
    public ListF<DavProperty> getProperties(DavPropertyName name) {
        return Option.ofNullable(getProperty(name));
    }

    @Override
    public DavPropertySet getProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(DavProperty<?> property) throws DavException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeProperty(DavPropertyName propertyName) throws DavException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MultiStatusResponse alterProperties(List<? extends PropEntry> changeList) throws DavException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DavResource getCollection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DavResourceIterator getMembers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeMember(DavResource member) throws DavException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(DavResource destination) throws DavException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(DavResource destination, boolean shallow) throws DavException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLockable(Type type, Scope scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasLock(Type type, Scope scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActiveLock getLock(Type type, Scope scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActiveLock[] getLocks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActiveLock refreshLock(LockInfo reqLockInfo, String lockToken) throws DavException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unlock(String lockToken) throws DavException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLockManager(LockManager lockmgr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DavResourceFactory getFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DavSession getSession() {
        throw new UnsupportedOperationException();
    }
}
