package ru.yandex.chemodan.app.webdav.repository;

import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.property.DavPropertyName;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;

/**
 * @author tolmalev
 */
public class DirectoryResource extends MpfsRealResourceBase {
    private final Option<ListF<DavResource>> children;

    public DirectoryResource(
            AuthInfo authInfo,
            MpfsFileInfo mpfsInfo,
            MpfsResourceManager factory,
            Option<ListF<DavResource>> children,
            ListF<DavPropertyName> hackDefaultProperties)
    {
        super(authInfo, mpfsInfo, factory, hackDefaultProperties);

        this.children = children;
    }

    @Override
    public DavResourceIterator getMembers() {
        if (children.isPresent()) {
            return new DavResourceIteratorImpl(children.get());
        } else {
            // load this resource again but now with children
            return manager.createResource(user, info.path.get(), additionalPropertiesToFetch, true).getMembers();
        }
    }
}
