package ru.yandex.chemodan.app.webdav.repository;

import java.util.Collection;
import java.util.Date;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import lombok.AllArgsConstructor;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.ResourceType;

import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.repository.properties.DavProperties;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.chemodan.mpfs.MpfsShareFolderInvite;

/**
 * @author tolmalev
 */
@AllArgsConstructor
public class MpfsInviteResource extends AbstractMpfsDavResource {
    private final AuthInfo authInfo;
    private final MpfsShareFolderInvite invite;

    @Override
    public String getSupportedMethods() {
        return "OPTIONS, GET";
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public AuthInfo getUser() {
        return authInfo;
    }

    public MpfsShareFolderInvite getInvite() {
        return invite;
    }

    @Override
    public String getRealPath() {
        return getHref();
    }

    @Override
    public MpfsFileInfo getFileInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDisplayName() {
        return invite.folderName;
    }

    @Override
    public String getHref() {
        return "/?share/not_approved/" + invite.hash;
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet set = new DavPropertySet();

        set.add(DavProperties.READONLY.cons(invite.isReadOnly() + ""));
        set.add(DavProperties.OWNER_NAME.cons(invite.ownerName));
        set.add(DavProperties.GETCONTENTLENGTH.cons(invite.size));
        set.add(DavProperties.DISPLAYNAME.cons(invite.folderName));

        set.add(DavProperties.CREATIONDATE.cons(ISO8601Utils.format(new Date(invite.ctime * 1000))));

        set.add(new ResourceType(ResourceType.DEFAULT_RESOURCE));

        return set;
    }

    @Override
    public long getModificationTime() {
        return 0;
    }

    @Override
    public boolean supportsStreamingPropfind() {
        return false;
    }

    @Override
    public void addFetchProperties(Collection<DavPropertyName> properties) {
        //DO NOTHING, only for mpfs files & folders prop fetching
    }
}
