package ru.yandex.chemodan.app.webdav.repository;

import java.util.Collection;

import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.ResourceType;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.repository.properties.DavProperties;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.chemodan.mpfs.MpfsShareFolderInvite;

/**
 * @author tolmalev
 */
public class MpfsInvitesListResource extends AbstractMpfsDavResource {
    private final ListF<MpfsInviteResource> invites;
    private final AuthInfo authInfo;

    public MpfsInvitesListResource(AuthInfo authInfo, ListF<MpfsShareFolderInvite> invites) {
        this.authInfo = authInfo;
        this.invites = invites.map((invite) -> new MpfsInviteResource(authInfo, invite));
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet set = new DavPropertySet();

        set.add(DavProperties.CREATIONDATE.cons("2000-01-01T12:00:00Z"));
        set.add(DavProperties.GETLASTMODIFIED.cons("Sat, 01 Jan 2000 12:00:00 GMT"));

        set.add(new ResourceType(ResourceType.COLLECTION));

        return set;
    }

    @Override
    public String getSupportedMethods() {
        return "OPTIONS, GET";
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public AuthInfo getUser() {
        return authInfo;
    }

    @Override
    public String getDisplayName() {
        return "/";
    }

    @Override
    public String getHref() {
        return "/?share/not_approved";
    }

    @Override
    public DavResourceIterator getMembers() {
        return new DavResourceIteratorImpl(invites.cast());
    }

    @Override
    public long getModificationTime() {
        return 0;
    }

    @Override
    public MpfsFileInfo getFileInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRealPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsStreamingPropfind() {
        return false;
    }

    @Override
    public void addFetchProperties(Collection<DavPropertyName> properties) {
        //DO NOTHING, only for mpfs files & folders prop fetching
    }
}
