package ru.yandex.chemodan.app.webdav.repository;

import java.util.Collection;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.jackrabbit.webdav.property.DavPropertyName;

import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;

/**
 * @author tolmalev
 */
@AllArgsConstructor
public class MpfsPublicResource extends AbstractMpfsDavResource {

    @Getter
    protected final AuthInfo user;
    protected final String privateHash;
    @Getter
    protected final MpfsFileInfo fileInfo;

    @Override
    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD";
    }

    @Override
    public boolean isCollection() {
        return !fileInfo.type.isSome("file");
    }

    @Override
    public String getDisplayName() {
        return fileInfo.name.get();
    }

    @Override
    public String getHref() {
        return "/?hash=" + privateHash;
    }

    @Override
    public long getModificationTime() {
        return fileInfo.times.mtime;
    }

    @Override
    public String getRealPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsStreamingPropfind() {
        return false;
    }

    @Override
    public void addFetchProperties(Collection<DavPropertyName> properties) {
        //DO NOTHING, only for mpfs files & folders prop fetching
    }
}
