package ru.yandex.chemodan.app.webdav.repository;

import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;

/**
 * @author tolmalev
 */
public abstract class MpfsRealResourceBase extends MpfsResourceBase implements DavResource {
    protected final MpfsFileInfo info;

    public MpfsRealResourceBase(AuthInfo authInfo, MpfsFileInfo info, MpfsResourceManager manager,
            ListF<DavPropertyName> hackDefaultProperties)
    {
        super(authInfo, manager, info.path.get(), hackDefaultProperties);
        this.info = info;
    }

    @Override
    public MpfsFileInfo getFileInfo() {
        return info;
    }

    @Override
    public DavProperty<?> getProperty(DavPropertyName name) {
        return getProperties(name).singleO().getOrNull();
    }

    @Override
    public ListF<DavProperty> getProperties(DavPropertyName name) {
        return manager.getProperties(() -> info, user, name);
    }

    @Override
    public DavPropertyName[] getPropertyNames() {
        return getProperties().getPropertyNames();
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet set = manager.getDefaultProperties(info, user);
        additionalPropertiesToFetch
                .map(this::getProperties)
                .filterNotNull()
                .flatMap(Function.identityF())
                .forEach(set::add);
        return set;
    }

    @Override
    public boolean isCollection() {
        return !info.type.isSome("file");
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return info.name.get();
    }

    @Override
    public long getModificationTime() {
        return info.times.mtime;
    }

    @Override
    public DavResourceIterator getMembers() {
        return new DavResourceIteratorImpl(Cf.list());
    }

    @Override
    public boolean supportsStreamingPropfind() {
        return true;
    }
}
