package ru.yandex.chemodan.app.webdav.repository;

import java.util.Collection;

import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;

/**
 * @author tolmalev
 */
public interface MpfsResource extends DavResource {

    AuthInfo getUser();
    String getRealPath();

    ListF<DavProperty> getProperties(DavPropertyName name);

    @Override
    String getDisplayName();

    MpfsFileInfo getFileInfo();

    boolean supportsStreamingPropfind();

    void addFetchProperties(Collection<DavPropertyName> properties);
}
