package ru.yandex.chemodan.app.webdav.repository;

import java.io.IOException;
import java.util.List;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.PropEntry;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;

/**
 * @author tolmalev
 */
public class MpfsUnloadedResource extends MpfsResourceBase {
    private Option<MpfsRealResourceBase> realResource = Option.empty();
    private final Function<ListF<DavPropertyName>, MpfsRealResourceBase> loadResourseFn;

    public MpfsUnloadedResource(String realPath, AuthInfo authInfo, MpfsResourceManager manager,
            ListF<DavPropertyName> additionalPropertiesToFetch,
            Function<ListF<DavPropertyName>, MpfsRealResourceBase> loadResourseFn)
    {
        super(authInfo, manager, realPath, additionalPropertiesToFetch);
        this.loadResourseFn = loadResourseFn;
    }

    private void loadRealResource() {
        if (realResource.isPresent()) {
            return;
        }
        DavResource resource = loadResourseFn.apply(additionalPropertiesToFetch);
        realResource = Option.of((MpfsRealResourceBase) resource);
    }

    public MpfsRealResourceBase getRealResource() {
        loadRealResource();
        return realResource.get();
    }

    @Override
    public DavProperty<?> getProperty(DavPropertyName name)
    {
        return getProperties(name).singleO().getOrNull();
    }

    @Override
    public ListF<DavProperty> getProperties(DavPropertyName name) {
        return getManager().getProperties(this::getFileInfo, getUser(), name);
    }

    @Override
    public DavPropertyName[] getPropertyNames() {
        return getRealResource().getPropertyNames();
    }

    @Override
    public DavPropertySet getProperties() {
        return getRealResource().getProperties();
    }

    @Override
    public void setProperty(DavProperty<?> property) throws DavException {
        getRealResource().setProperty(property);
    }

    @Override
    public void removeProperty(DavPropertyName propertyName) throws DavException {
        getRealResource().removeProperty(propertyName);
    }

    @Override
    public MultiStatusResponse alterProperties(
            List<? extends PropEntry> changeList) throws DavException
    {
        return getRealResource().alterProperties(changeList);
    }

    @Override
    public boolean isCollection() {
        return getRealResource().isCollection();
    }

    @Override
    public boolean exists() {
        return getRealResource().exists();
    }

    @Override
    public long getModificationTime() {
        return getRealResource().getModificationTime();
    }

    @Override
    public DavResourceIterator getMembers() {
        return getRealResource().getMembers();
    }

    @Override
    public void removeMember(DavResource member) throws DavException {
        getRealResource().removeMember(member);
    }

    @Override
    public void move(DavResource destination) throws DavException {
        getRealResource().move(destination);
    }

    @Override
    public void copy(DavResource destination, boolean shallow) throws DavException {
        getRealResource().copy(destination, shallow);
    }

    @Override
    public void spool(OutputContext outputContext) throws IOException {
        getRealResource().spool(outputContext);
    }

    @Override
    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        getRealResource().addMember(resource, inputContext);
    }

    @Override
    public MpfsFileInfo getFileInfo() {
        return getRealResource().getFileInfo();
    }

    @Override
    public boolean supportsStreamingPropfind() {
        return true; // for prevert loading resource in case of streaming
        //return getRealResource().supportsStreamingPropfind();
    }
}
