package ru.yandex.chemodan.app.webdav.repository;

import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.servlet.MultipleRequest;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
public class PathUtils {
    private static final String URL_PATH_SAFE_CHARS =
            "-._~" +       // Unreserved characters.
            "!$'(),&=" +   // The subdelim characters (excluding '+').
            "@";           // The gendelim characters permitted in paths.

    private static final Escaper pathSegmentEscaper =
            new PercentEscaper(URL_PATH_SAFE_CHARS, false);

    //TODO: check encoding
    public static String encodePath(String path) {
        return Cf
                .list(path.split("/"))
                .map(pathSegmentEscaper::escape)
                .mkString("/");
    }

    public static String encodeCollectionPath(String p) {
        String path = encodePath(p);
        return path + (path.endsWith("/") ? "" : "/");
    }

    public static String decodePath(String path) {
        return Cf
                .list(path.split("/"))
                .map(s -> s.replace("+", "%2B"))
                .map(UrlUtils::urlDecode)
                .mkString("/");
    }

    public static ListF<String> getSourcePaths(MultipleRequest multiple, String pathFromUrl) {
        return multiple.paths.map(path -> getOneMultiplePath(path, pathFromUrl));
    }

    public static String getOneMultiplePath(String path, String pathFromUrl) {
        return isAbsolute(path) ? path : toCollectionPath(pathFromUrl) + path;
    }

    public static String href(String realPath, AuthInfo authInfo) {
        return href(realPath, authInfo.clientCapabilities.getBaseLocation());
    }

    public static String href(String realPath, String baseLocation) {
        String href = StringUtils.removeStart(realPath, baseLocation);

        return PathUtils.encodePath(href);
    }

    private static String toCollectionPath(String path) {
        return path + (path.endsWith("/") ? "" : "/");
    }

    private static boolean isAbsolute(String path) {
        return path.startsWith("/");
    }

    public static String getDisplayName(String realPath) {
        return Cf.list(realPath.split("/")).last();
    }

    public static String childPath(String folderPath, String displayName) {
        return folderPath + (folderPath.endsWith("/") ? "" : "/") + displayName;
    }

    static String parentPath(String realPath) {
        if (StringUtils.isBlank(realPath) || realPath.equals("/")) {
            return "/";
        }

        realPath = StringUtils.removeEnd(realPath, "/");
        return StringUtils.substring(realPath, 0, realPath.lastIndexOf("/"));
    }
}
