package ru.yandex.chemodan.app.webdav.repository;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class PathUtilsTest {
    //TODO: add tests
    @Test
    public void encodePath() {
        Assert.equals("/asd/%20/asd", PathUtils.encodePath("/asd/ /asd"));
        Assert.equals("/.-~_@%3A!$%3B'()%2A%2B,%3B=", PathUtils.encodePath("/.-~_@:!$;'()*+,;="));
        Assert.equals("/test%3Btest.jpg", PathUtils.encodePath("/test;test.jpg"));
    }

    @Test
    public void decodePath() {
        Assert.equals("/asd/ /asd", PathUtils.decodePath("/asd/%20/asd"));
        Assert.equals("/.-~_@:!$;'()*+,;=", PathUtils.decodePath("/.-~_@%3A!$%3B'()%2A%2B,%3B="));
        Assert.equals("/test;test.jpg", PathUtils.decodePath("/test%3Btest.jpg"));
    }

    @Test
    public void parentPath() {
        Assert.equals("/", PathUtils.parentPath("/"));
        Assert.equals("/", PathUtils.parentPath(""));

        Assert.equals("/disk", PathUtils.parentPath("/disk/asd"));
        Assert.equals("/disk", PathUtils.parentPath("/disk/asd/"));
        Assert.equals("/disk/asd", PathUtils.parentPath("/disk/asd/asdasd"));
    }

    @Test
    public void testGetDisplayName() {
        Assert.equals("c", PathUtils.getDisplayName("a/b/c"));
    }

    @Test
    public void testChildPath() {
        Assert.equals("a/b/c/d", PathUtils.childPath("a/b/c", "d"));
    }

    @Test
    public void testEncodeCollectionPath() {
        Assert.equals("a/b/c/", PathUtils.encodeCollectionPath("a/b/c"));
    }

}
