package ru.yandex.chemodan.app.webdav.repository;

import org.apache.jackrabbit.webdav.AbstractLocatorFactory;

public class SimpleLocatorFactory extends AbstractLocatorFactory {

    /**
     * Create a new factory
     *
     * @param pathPrefix Prefix, that needs to be removed in order to retrieve
     *                   the path of the repository item from a given <code>DavResourceLocator</code>.
     */
    public SimpleLocatorFactory(String pathPrefix) {
        super(pathPrefix);
    }

    @Override
    protected String getRepositoryPath(String resourcePath, String wspPath) {
        return resourcePath;
    }

    @Override
    protected String getResourcePath(String repositoryPath, String wspPath) {
        return repositoryPath;
    }

}
