package ru.yandex.chemodan.app.webdav.repository.properties;

import java.util.function.Supplier;

import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.misc.bender.parse.BenderJsonNode;

/**
 * @author tolmalev
 */
public class ClientMetaPropertiesFactory implements PropertiesFactory {
    @Override
    public int order() {
        return 3;
    }

    @Override
    public boolean accepts(DavPropertyName name) {
        // allow Win32FileAttributes and all unknown properties
        return  name.equals(DavProperties.MS_ATTR.name) || !DavProperties.find(name).isPresent();
    }

    @Override
    public Option<DavProperty> cons(Supplier<MpfsFileInfo> info, AuthInfo authInfo, DavPropertyName name) {
        return info.get().getMeta().getMetaJsonField(DavPropertyNameUtils.getCustomPropertyNameSafe(name))
                .filter(BenderJsonNode::isString)
                .map(BenderJsonNode::getValueAsString)
                .map(XmlPropertyUtils::hackYadropXml)
                .map(v -> new DefaultDavProperty(name, v));
    }

    @Override
    public ListF<String> getMetaFields(DavPropertyName name) {
        return Cf.list(DavPropertyNameUtils.getCustomPropertyNameSafe(name));
    }
}
