package ru.yandex.chemodan.app.webdav.repository.properties;

import java.util.function.Supplier;

import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;
import ru.yandex.chemodan.app.webdav.repository.PathUtils;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.misc.xml.dom.DomUtils;

/**
 * @author tolmalev
 */
public class CustomPropertiesFactory implements PropertiesFactory {
    private final MpfsClient mpfsClient;

    public static final MapF<DavPropertyName, OnePropertyFactory<MpfsClient>> properties = Cf.list(
        new OnePropertyFactory<MpfsClient>(DavProperties.DEFAULT_FOLDERS,
            (client, auth) -> {
                Document document = DomUtils.newDocument();

                return Option.of(client.getDefaultFolders(auth)
                    .entries()
                    .map(t2 -> {
                        Element element = document.createElement(t2._1);
                        element.setTextContent(PathUtils.encodeCollectionPath(t2._2));
                        return element;
                    }));
            }
        )
    ).toMapMappingToKey(OnePropertyFactory::getName);

    public CustomPropertiesFactory(MpfsClient mpfsClient) {
        this.mpfsClient = mpfsClient;
    }

    @Override
    public boolean accepts(DavPropertyName name) {
        return properties.containsKeyTs(name);
    }

    @Override
    public ListF<DavProperty> cons(Supplier<MpfsFileInfo> info, AuthInfo auth, DavPropertyName name) {
        return properties.getO(name).flatMapO(p -> p.cons(mpfsClient, auth));
    }

    @Override
    public int order() {
        return 2;
    }
}
