package ru.yandex.chemodan.app.webdav.repository.properties;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.mpfs.MpfsClient;

/**
 * @author tolmalev
 */
@Configuration
public class DavPropertiesContextConfiguration {
    @Bean
    public MetaPropertiesFactory metaPropertiesFactory() {
        return new MetaPropertiesFactory();
    }

    @Bean
    public CustomPropertiesFactory customPropertiesFactory(MpfsClient mpfsClient) {
        return new CustomPropertiesFactory(mpfsClient);
    }

    @Bean
    public UserInfoPropertyFactory userInfoPropertyFactory(MpfsClient mpfsClient) {
        return new UserInfoPropertyFactory(mpfsClient);
    }

    @Bean
    public ClientMetaPropertiesFactory clientMetaPropertiesFactory() {
        return new ClientMetaPropertiesFactory();
    }
}
