package ru.yandex.chemodan.app.webdav.repository.properties;

import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.junit.Test;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class DavPropertiesTest {
    @Test
    public void getAllProperties() {
        Assert.isTrue(DavProperties.all.length() > 10);
    }

    @Test
    public void find() {
        Assert.some(DavProperties.SIZE, DavProperties.find(DavPropertyName.create("size", Namespace.EMPTY_NAMESPACE)));
    }

    @Test
    public void allReadableHasConverters() {
        ListF<DavProperties.PropertyDescription> unknown = DavProperties.all.filter(pd -> pd.isAllowRead())
                // Win32FileAttributes are converted by ClientMetaPropertiesFactory
                .filter(pd -> !pd.name.equals(DavProperties.MS_ATTR.name))
                .filter(pd ->
                !UserInfoPropertyFactory.properties
                        .getO(pd.name)
                        .cast()
                        .orElse(Option.when(pd.name == DavProperties.STATE_ALLPROP.name, new Object()))
                        .orElse(MetaPropertiesFactory.properties.getO(pd.name))
                        .orElse(CustomPropertiesFactory.properties.getO(pd.name))
                        .isPresent()
        );

        Assert.isTrue(unknown.isEmpty(), unknown.map(pd -> pd.name).mkString("\n", "\n", ""));
    }

    @Test
    public void nonReadableHasNoConverters() {
        ListF<DavProperties.PropertyDescription> unknown = DavProperties.all.filter(pd -> !pd.isAllowRead()).filter(pd ->
                UserInfoPropertyFactory.properties
                        .getO(pd.name)
                        .cast()
                        .orElse(MetaPropertiesFactory.properties.getO(pd.name))
                        .orElse(CustomPropertiesFactory.properties.getO(pd.name))
                        .isPresent()
        );

        Assert.isTrue(unknown.isEmpty(), unknown.map(pd -> pd.name).mkString("\n", "\n", ""));
    }
}
