package ru.yandex.chemodan.app.webdav.repository.properties;

import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.Namespace;

import ru.yandex.bolts.collection.Option;

/**
 * @author yashunsky
 */
public class DavPropertyNameUtils {
    public static String getCustomPropertyNameSafe(DavPropertyName name) {
        return name.getName() + "|" + Option.ofNullable(name.getNamespace()).map(Namespace::getURI).getOrElse("");
    }
}
