package ru.yandex.chemodan.app.webdav.repository.properties;

import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.chemodan.app.webdav.auth.AuthInfo;

/**
 * @author tolmalev
 */
public class OnePropertyFactory<T> {

    private final DavPropertyName name;
    private final Function2<T, AuthInfo, Option<?>> valueF;

    public OnePropertyFactory(DavProperties.PropertyDescription descriptor, Function2<T, AuthInfo, Option<?>> valueF) {
        this(descriptor.name, valueF);
    }

    public OnePropertyFactory(DavProperties.PropertyDescription descriptor, Function<T, Option<?>> valueF) {
        this(descriptor, toFunction2(valueF));
    }

    public OnePropertyFactory(DavPropertyName name, Function2<T, AuthInfo, Option<?>> valueF) {
        this.name = name;
        this.valueF = valueF;
    }

    private static <T> Function2<T, AuthInfo, Option<?>> toFunction2(Function<T, Option<?>> valueF) {
        return (a, b) -> valueF.apply(a);
    }

    public Option<DavProperty> cons(T info, AuthInfo authInfo) {
        return valueF.apply(info, authInfo)
                .map(value -> {
                    if (value instanceof DavProperty) {
                        return (DavProperty) value;
                    }
                    return new DefaultDavProperty(name, value);
                });
    }

    public DavPropertyName getName() {
        return name;
    }
}
